﻿using System;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Collections;
using System.Drawing;
using System.Linq;
using System.Workflow.ComponentModel.Compiler;
using System.Workflow.ComponentModel.Serialization;
using System.Workflow.ComponentModel;
using System.Workflow.ComponentModel.Design;
using System.Workflow.Runtime;
using System.Workflow.Activities;
using System.Workflow.Activities.Rules;



/*      Faults: throwing and handling
 
 
        This sample contains a ThrowActivity which is thrown if the number N is < 0 or > 9.
        That ThrowActivity throws a NumberOutOfRangeException defined as a nested class
        to the workflow. 
 
        A FaultHandlerActivity, local to the actNumberCondition IfElseActivity handles any
        NumberOutOfRangeException exception. 
 
        A global FaultHandlerActivity defined at the workflow level handles any other type
        of exception.
 
 */
namespace Lessons.Workflows
{
	public sealed partial class Workflow1: SequentialWorkflowActivity
	{
		public Workflow1()
		{
			InitializeComponent();
		}

        public class NumberOutOfRangeException : ApplicationException
        {
            public NumberOutOfRangeException()
                : this("Number is out of range")
            {
            }

            public NumberOutOfRangeException(string message)
                : base(message)
            {
            }
        }

        int N;

        private void actNumberInput_ExecuteCode(object sender, EventArgs e)
        {
            Activity a = sender as Activity;
            Console.WriteLine(a.Name + ": Enter a number between 0 and 9...");
            N = int.Parse(Console.ReadLine()); 
        }

        void actNumberLess_Condition(object sender, ConditionalEventArgs e)
        {
            e.Result = (N >= 0) && (N <= 5)  ;
        }

        void actNumberGreater_Condition(object sender, ConditionalEventArgs e)
        {
            e.Result = (N > 5) && (N <= 9);
        }

        private void actProcessLess_ExecuteCode(object sender, EventArgs e)
        {
            Activity a = sender as Activity;
            Console.WriteLine(a.Name + ": (N >= 0) && (N <= 5)");
        }

        private void actProcessGreater_ExecuteCode(object sender, EventArgs e)
        {
            Activity a = sender as Activity;
            Console.WriteLine(a.Name + ": (N > 5) && (N <= 9)");
        }

        /* there is no Condition for this case, since it's the last else in the branch */
        private void actProcessElse_ExecuteCode(object sender, EventArgs e)
        {
            Activity a = sender as Activity;
            Console.WriteLine(a.Name + ": Number is out of range. An exception will be thrown");
        }

        private void actLocalFaultCode_ExecuteCode(object sender, EventArgs e)
        {
            Activity a = sender as Activity;
            Console.WriteLine(a.Name + ": handling local fault: {0}", actNumberOutOfRangeFaultHandler.Fault.Message);
        }

        private void actGeneralFaultCode_ExecuteCode(object sender, EventArgs e)
        {
            Activity a = sender as Activity;
            Console.WriteLine(a.Name + ": handling a very bad general fault: {0}", actGeneralFaultHandler.Fault.Message);
        }
	}

}
